/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.view;

import br.gov.pe.tce.applet.entidades.AssinadorRequest;
import br.gov.pe.tce.applet.service.ServiceNovo;
import br.gov.pe.tce.applet.util.AuthUtil;
import br.gov.pe.tce.applet.util.JTextFieldLimit;
import br.gov.pe.tce.applet.view.AssinadorNovo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class LoginFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static JLabel passwordLabel;
    private static JLabel label;
    private static JTextField usernameText;
    private static JButton buttonLogin;
    private static JPasswordField passwordField;
    private String urlAssinador;
    private String hashSolicitacao;
    private AssinadorRequest assinadorRequest;
    JLabel logo;

    public void preInit(String hashSolicitacao, String urlAssinador) {
        this.hashSolicitacao = hashSolicitacao;
        this.urlAssinador = urlAssinador;
        this.setTitle("Assinatura Digital de Documentos");
        this.setLayout(null);
        this.setSize(500, 300);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        JPanel panelPrincipal = this.createJPanelPrincipal();
        this.getLayeredPane().add((Component)panelPrincipal, JLayeredPane.DEFAULT_LAYER);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private JPanel createJPanelPrincipal() {
        JPanel p = new JPanel();
        p.setSize(500, 250);
        p.setLayout(new BorderLayout());
        p.add((Component)this.createCentro(), "Center");
        JPanel panelButton = new JPanel(new GridLayout());
        panelButton.setBorder(new EmptyBorder(0, 160, 30, 160));
        buttonLogin = new JButton("Entrar");
        buttonLogin.addActionListener(this);
        panelButton.add(buttonLogin);
        p.add((Component)panelButton, "South");
        p.add((Component)this.createTopo(), "North");
        return p;
    }

    private JPanel createCentro() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setBorder(new EmptyBorder(10, 160, 10, 160));
        JPanel p1 = new JPanel(new GridLayout(2, 1));
        label = new JLabel("Login");
        p1.add(label);
        usernameText = new JTextField();
        usernameText.setDocument(new JTextFieldLimit(11));
        p1.add(usernameText);
        JPanel p2 = new JPanel(new GridLayout(2, 1));
        passwordLabel = new JLabel("Senha");
        p2.add(passwordLabel);
        passwordField = new JPasswordField();
        p2.add(passwordField);
        passwordField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    buttonLogin.doClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        panel.add(p1);
        panel.add(p2);
        return panel;
    }

    private JPanel createTopo() {
        JPanel panelLogo = new JPanel(new GridLayout(1, 1));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/LogoTCE.png"));
        this.logo = new JLabel(icon);
        this.logo.setBounds(0, 200, 200, 30);
        panelLogo.add(this.logo);
        return panelLogo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block7: {
            String username = usernameText.getText();
            String password = String.valueOf(passwordField.getPassword());
            if (username.isEmpty() || password.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Informe o login e a senha!", null, 2);
                return;
            }
            try {
                String accessToken = AuthUtil.getAccessToken(username, password);
                if (accessToken != null) {
                    this.assinadorRequest = new AssinadorRequest(this.hashSolicitacao, this.urlAssinador, username, password);
                    try {
                        Boolean usuarioLogadoIgual = new ServiceNovo().verificarSeUsuarioLogadoEoMesmoSolicitacao(this.assinadorRequest);
                        if (usuarioLogadoIgual.booleanValue()) {
                            this.setVisible(false);
                            new AssinadorNovo().init(this.assinadorRequest);
                            break block7;
                        }
                        JOptionPane.showMessageDialog(null, "Usu\u00e1rio logado diferente do que realizou a solicita\u00e7\u00e3o. Voc\u00ea n\u00e3o pode abrir uma solicita\u00e7\u00e3o de outro usu\u00e1rio!", null, 0);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, ex.getMessage(), null, 0);
                    }
                    break block7;
                }
                JOptionPane.showMessageDialog(null, "Login e/ou senha inv\u00e1lidos!", null, 0);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "N\u00e3o foi poss\u00edvel realizar o login!", null, 0);
                ex.printStackTrace();
            }
        }
    }
}

