/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.view;

import br.gov.pe.tce.applet.entidades.ArquivoAssinatura;
import br.gov.pe.tce.applet.entidades.AssinadorRequest;
import br.gov.pe.tce.applet.entidades.SolicitacaoArquivo;
import br.gov.pe.tce.applet.service.ConexaoAssinadorNovo;
import br.gov.pe.tce.applet.service.ServiceNovo;
import br.gov.pe.tce.applet.token.ComunicacaoToken;
import br.gov.pe.tce.applet.token.SmartCardKeyStore;
import br.gov.pe.tce.applet.util.AssinadorException;
import br.gov.pe.tce.applet.view.MyTableModelNovo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.Provider;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class AssinadorNovo
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static JButton bAssinar = new JButton("Assinar");
    private static JButton bFechar = new JButton("Fechar");
    JLabel logo;
    JTable jtable;
    private static JPasswordField senha = new JPasswordField(15);
    private ServiceNovo service = new ServiceNovo();
    private JProgressBar progressBar;
    private Provider pkcsProvider;
    private boolean exibirSenha;
    private String tipoSolicitacao;
    private List<SolicitacaoArquivo> listaArquivos;
    private AssinadorRequest assinadorRequest;
    private static boolean ASSINATURA_EM_ANDAMENTO = false;

    public void init(AssinadorRequest assinadorRequest) throws IOException {
        this.assinadorRequest = assinadorRequest;
        if (this.assinadorRequest == null) {
            JOptionPane.showMessageDialog(null, "N\u00e3o foi poss\u00edvel iniciar o assinador: argumentos n\u00e3o informados!", null, 0);
        } else {
            try {
                this.listaArquivos = this.service.getArquivosSolicitacaoAssinatura(assinadorRequest);
                if (!this.listaArquivos.isEmpty()) {
                    this.tipoSolicitacao = this.listaArquivos.get(0).getTipoSolicitacao();
                }
                this.abrirConexaoToken();
                this.propriedadesFrame();
            }
            catch (AssinadorException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), null, 0);
                e.printStackTrace();
            }
        }
    }

    private void propriedadesFrame() {
        this.setTitle("Assinatura Digital de Documentos");
        this.setLayout(null);
        this.setSize(1000, 450);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        JPanel panelPrincipal = this.createJPanelPrincipal();
        this.getLayeredPane().add((Component)panelPrincipal, JLayeredPane.DEFAULT_LAYER);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(this.progressBar.getMinimum());
        this.progressBar.setStringPainted(true);
        this.progressBar.setSize(500, 20);
        this.progressBar.setLocation((this.getWidth() - this.progressBar.getWidth()) / 2, this.getHeight() * 380 / 1000);
        this.progressBar.setVisible(false);
        this.getLayeredPane().add((Component)this.progressBar, JLayeredPane.MODAL_LAYER);
        bAssinar.addActionListener(this);
        bFechar.addActionListener(this);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private JPanel createJPanelPrincipal() {
        JPanel p = new JPanel();
        p.setBounds(0, 5, 1000, 400);
        p.setLayout(new BorderLayout());
        p.add((Component)this.createCentro(), "Center");
        p.add((Component)this.createTopo(), "North");
        p.add((Component)this.rodape(), "South");
        return p;
    }

    private void abrirConexaoToken() throws IOException {
        ComunicacaoToken token = new ComunicacaoToken();
        this.pkcsProvider = token.loadSmartCardDLL();
        this.exibirSenha = this.pkcsProvider != null;
    }

    private JTable createJtableArquivos(MyTableModelNovo model) {
        if (model == null) {
            model = new MyTableModelNovo();
            for (SolicitacaoArquivo arquivo : this.listaArquivos) {
                String tipoArquivo = arquivo.getTipoArquivo();
                String nomeArquivo = arquivo.getNomeArquivo();
                List<ArquivoAssinatura> assinaturas = arquivo.getAssinaturas();
                String codigoArquivo = "";
                boolean assinado = false;
                if (!assinaturas.isEmpty()) {
                    if (arquivo.getCodigoArquivo() != null) {
                        codigoArquivo = arquivo.getCodigoArquivo();
                    }
                    assinado = true;
                }
                model.addRow(new Object[]{tipoArquivo, nomeArquivo, assinado, codigoArquivo});
            }
        }
        this.jtable = new JTable(model){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jtable.setSelectionMode(0);
        this.jtable.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.jtable.setCellSelectionEnabled(true);
        this.jtable.getColumnModel().getColumn(0).setCellRenderer(new TextCenterRenderer());
        this.jtable.getColumnModel().getColumn(2).setCellRenderer(new IconRenderer());
        this.jtable.getColumnModel().getColumn(0).setPreferredWidth(260);
        this.jtable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jtable.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.jtable.getColumnModel().getColumn(3).setPreferredWidth(180);
        return this.jtable;
    }

    private JPanel createTopo() {
        JPanel pTotal = new JPanel(new GridLayout(2, 1));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/LogoTCE.png"));
        this.logo = new JLabel(icon);
        this.logo.setBounds(0, 20, 200, 30);
        pTotal.add(this.logo);
        JPanel panelLabels = new JPanel(new GridLayout(1, 1));
        panelLabels.setBorder(new EmptyBorder(10, 10, 0, 0));
        JTextPane labelSolicitacao = new JTextPane();
        labelSolicitacao.setContentType("text/html");
        labelSolicitacao.setText("<html><b>Hash de Solicita\u00e7\u00e3o: </b>" + (this.assinadorRequest.getHashSolicitacao() != null ? this.assinadorRequest.getHashSolicitacao() : "") + "<br/><b>Tipo de Solicita\u00e7\u00e3o: </b>" + (this.tipoSolicitacao != null ? this.tipoSolicitacao : "") + "</html>");
        labelSolicitacao.setEditable(false);
        labelSolicitacao.setBackground(null);
        labelSolicitacao.setBorder(null);
        labelSolicitacao.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        panelLabels.add(labelSolicitacao);
        pTotal.add(panelLabels);
        return pTotal;
    }

    private JPanel createCentro() {
        JPanel pTotal = new JPanel(new GridLayout(1, 1));
        pTotal.setBorder(new EmptyBorder(10, 10, 0, 23));
        pTotal.add(new JScrollPane(this.createJtableArquivos(null)));
        return pTotal;
    }

    private JPanel rodape() {
        JPanel p = new JPanel(new GridLayout(1, 1));
        if (this.exibirSenha) {
            p.add(this.rodape1());
            p.add(this.rodape2());
        }
        return p;
    }

    private JPanel rodape1() {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Senha Token (PIN):   ");
        p.add(label);
        senha.setEnabled(true);
        p.add(senha);
        return p;
    }

    private JPanel rodape2() {
        JPanel p = new JPanel();
        bAssinar.setEnabled(true);
        p.add(bAssinar);
        bFechar.setEnabled(true);
        p.add(bFechar);
        return p;
    }

    public void reabilitarBotoesAposAssinatura() {
        ASSINATURA_EM_ANDAMENTO = false;
        bAssinar.setEnabled(true);
        bFechar.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Assinar")) {
            bAssinar.setEnabled(false);
            bFechar.setEnabled(false);
            if (!ASSINATURA_EM_ANDAMENTO) {
                ASSINATURA_EM_ANDAMENTO = true;
                final String senha = new String(AssinadorNovo.senha.getPassword());
                if (this.exibirSenha && senha.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Digite a senha do token!", null, 2);
                    this.reabilitarBotoesAposAssinatura();
                } else {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            block15: {
                                try {
                                    DefaultTableModel modelArquivos = (DefaultTableModel)AssinadorNovo.this.jtable.getModel();
                                    Vector<Vector> pendentesAssinatura = new Vector<Vector>();
                                    int i = 0;
                                    while (i < modelArquivos.getDataVector().size()) {
                                        Vector dados = modelArquivos.getDataVector().get(i);
                                        if (!((Boolean)dados.get(2)).booleanValue()) {
                                            pendentesAssinatura.add(dados);
                                        }
                                        ++i;
                                    }
                                    if (pendentesAssinatura.isEmpty()) {
                                        JOptionPane.showMessageDialog(null, "N\u00e3o existem documentos dispon\u00edveis para assinar!", null, 2);
                                        return;
                                    }
                                    try {
                                        AssinadorNovo.this.progressBar.setVisible(true);
                                        AssinadorNovo.this.progressBar.setMinimum(0);
                                        AssinadorNovo.this.progressBar.setMaximum(pendentesAssinatura.size());
                                        AssinadorNovo.this.progressBar.setValue(AssinadorNovo.this.progressBar.getMinimum());
                                        ComunicacaoToken token = new ComunicacaoToken();
                                        SmartCardKeyStore keyStore = token.abrirConexaoToken(AssinadorNovo.this.pkcsProvider, senha);
                                        if (keyStore == null) break block15;
                                        int docAssinados = 0;
                                        int i2 = 0;
                                        while (i2 < modelArquivos.getDataVector().size()) {
                                            Vector dados = modelArquivos.getDataVector().get(i2);
                                            boolean jaAssinado = (Boolean)dados.get(2);
                                            if (!jaAssinado) {
                                                SolicitacaoArquivo arquivo = ConexaoAssinadorNovo.listaTotal.get(i2);
                                                String hashLocalizacao = AssinadorNovo.this.service.assinarDocumento(AssinadorNovo.this.assinadorRequest, arquivo, keyStore);
                                                if (hashLocalizacao != null) {
                                                    modelArquivos.setValueAt(Boolean.TRUE, i2, 2);
                                                    modelArquivos.setValueAt(arquivo.getCodigoArquivo(), i2, 3);
                                                    ++docAssinados;
                                                }
                                                AssinadorNovo.this.progressBar.setValue(i2 + 1);
                                            }
                                            ++i2;
                                        }
                                        AssinadorNovo.this.progressBar.setVisible(false);
                                        if (docAssinados == 0) {
                                            JOptionPane.showMessageDialog(null, "Nenhum documento foi assinado!", null, 2);
                                            break block15;
                                        }
                                        if (docAssinados < pendentesAssinatura.size()) {
                                            JOptionPane.showMessageDialog(null, "Apenas " + docAssinados + " de " + pendentesAssinatura.size() + " documentos foram assinados com sucesso!", null, 2);
                                            break block15;
                                        }
                                        if (docAssinados == 1) {
                                            JOptionPane.showMessageDialog(null, "Documento assinado com sucesso!", null, 1);
                                            break block15;
                                        }
                                        JOptionPane.showMessageDialog(null, String.valueOf(docAssinados) + " documentos assinados com sucesso!", null, 1);
                                    }
                                    catch (Exception e) {
                                        AssinadorNovo.this.progressBar.setVisible(false);
                                        JOptionPane.showMessageDialog(null, "N\u00e3o foi poss\u00edvel assinar os documentos: " + e.getMessage(), null, 0);
                                        e.printStackTrace();
                                    }
                                }
                                finally {
                                    AssinadorNovo.this.reabilitarBotoesAposAssinatura();
                                }
                            }
                        }
                    }).start();
                }
            }
        } else if (e.getActionCommand().equals("Fechar")) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    class IconRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String iconName = "unchecked.png";
            if (Boolean.TRUE == value) {
                iconName = "checked.png";
            }
            label.setIcon(new ImageIcon(this.getClass().getResource("/" + iconName)));
            label.setText("");
            label.setHorizontalAlignment(0);
            return label;
        }
    }

    class TextCenterRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        TextCenterRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setHorizontalAlignment(0);
            return label;
        }
    }
}

