/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.view;

import br.gov.pe.tce.applet.entidades.Documentos;
import br.gov.pe.tce.applet.service.ConexaoAssinador;
import br.gov.pe.tce.applet.service.Service;
import br.gov.pe.tce.applet.token.ComunicacaoToken;
import br.gov.pe.tce.applet.token.SmartCardKeyStore;
import br.gov.pe.tce.applet.view.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class Assinador
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static JButton bAssinar = new JButton("Assinar");
    private static JButton bFechar = new JButton("Fechar");
    JLabel logo;
    JTable jtable;
    private static JPasswordField senha = new JPasswordField(15);
    private String ids;
    private String urlAssinador;
    private Service service = new Service();
    private boolean carregouArquivos = false;
    private JProgressBar progressBar;
    private Provider pkcsProvider;
    private boolean exibirSenha;

    public void init(String ids, String urlAssinador) throws IOException {
        this.ids = ids;
        this.urlAssinador = urlAssinador;
        if (this.ids == null || this.urlAssinador == null) {
            JOptionPane.showMessageDialog(null, "N\u00e3o foi poss\u00edvel iniciar o assinador: argumentos n\u00e3o informados!", null, 0);
        } else {
            this.propriedadesFrame();
        }
    }

    private void propriedadesFrame() throws IOException {
        this.setTitle("Assinatura Digital de Documentos");
        this.setLayout(null);
        this.setSize(800, 450);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        JPanel panelPrincipal = this.createJPanelPrincipal();
        this.getLayeredPane().add((Component)panelPrincipal, JLayeredPane.DEFAULT_LAYER);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(this.progressBar.getMinimum());
        this.progressBar.setStringPainted(true);
        this.progressBar.setSize(500, 20);
        this.progressBar.setLocation((this.getWidth() - this.progressBar.getWidth()) / 2, this.getHeight() * 380 / 1000);
        this.progressBar.setVisible(false);
        this.getLayeredPane().add((Component)this.progressBar, JLayeredPane.MODAL_LAYER);
        bAssinar.addActionListener(this);
        bFechar.addActionListener(this);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private JPanel createJPanelPrincipal() throws IOException {
        JPanel p = new JPanel();
        p.setBounds(0, 5, 800, 400);
        p.setLayout(new BorderLayout());
        p.add((Component)this.createTopo(), "North");
        p.add((Component)this.createCentro(), "Center");
        if (this.carregouArquivos) {
            this.abrirConexaoToken();
        }
        p.add((Component)this.rodape(), "South");
        return p;
    }

    private void abrirConexaoToken() throws IOException {
        ComunicacaoToken token = new ComunicacaoToken();
        this.pkcsProvider = token.loadSmartCardDLL();
        this.exibirSenha = this.pkcsProvider != null;
    }

    private JTable createJtableArquivos(MyTableModel model) {
        if (model == null) {
            try {
                model = this.service.gerarDocumentosParaAssinar(this.ids, this.urlAssinador);
                this.carregouArquivos = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "N\u00e3o foi poss\u00edvel carregar os documentos: " + e.getMessage(), null, 0);
                model = new MyTableModel();
                this.carregouArquivos = false;
                e.printStackTrace();
            }
        }
        this.jtable = new JTable(model){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jtable.setSelectionMode(0);
        this.jtable.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.jtable.setCellSelectionEnabled(true);
        this.jtable.getColumnModel().getColumn(0).setPreferredWidth(10);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.jtable.getColumnModel().getColumn(0).setCellRenderer(centerRenderer);
        this.jtable.getColumnModel().getColumn(2).setCellRenderer(new IconRenderer());
        this.jtable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jtable.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.jtable.getColumnModel().getColumn(3).setPreferredWidth(200);
        return this.jtable;
    }

    private JPanel createTopo() {
        JPanel pTotal = new JPanel(new GridLayout(1, 1));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/LogoTCE.png"));
        this.logo = new JLabel(icon);
        this.logo.setBounds(0, 20, 200, 30);
        pTotal.add(this.logo);
        return pTotal;
    }

    private JPanel createCentro() {
        JPanel pTotal = new JPanel(new GridLayout(1, 1));
        pTotal.setBorder(new EmptyBorder(10, 10, 0, 23));
        pTotal.add(new JScrollPane(this.createJtableArquivos(null)));
        return pTotal;
    }

    private JPanel rodape() {
        JPanel p = new JPanel(new GridLayout(1, 1));
        if (this.exibirSenha) {
            p.add(this.rodape1());
        }
        p.add(this.rodape2());
        return p;
    }

    private JPanel rodape1() {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Senha Token (PIN):   ");
        p.add(label);
        senha.setEnabled(this.carregouArquivos);
        p.add(senha);
        return p;
    }

    private JPanel rodape2() {
        JPanel p = new JPanel();
        bAssinar.setEnabled(this.carregouArquivos);
        p.add(bAssinar);
        bFechar.setEnabled(this.carregouArquivos);
        p.add(bFechar);
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Assinar")) {
            final String senha = new String(Assinador.senha.getPassword());
            if (this.exibirSenha && senha.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Digite a senha do token!", null, 2);
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DefaultTableModel modelArquivos = (DefaultTableModel)Assinador.this.jtable.getModel();
                            Vector<Vector> pendentesAssinatura = new Vector<Vector>();
                            int i = 0;
                            while (i < modelArquivos.getDataVector().size()) {
                                Vector dados = modelArquivos.getDataVector().get(i);
                                if (!((Boolean)dados.get(2)).booleanValue()) {
                                    pendentesAssinatura.add(dados);
                                }
                                ++i;
                            }
                            if (pendentesAssinatura.isEmpty()) {
                                JOptionPane.showMessageDialog(null, "N\u00e3o existem documentos dispon\u00edveis para assinar!", null, 2);
                                return;
                            }
                            bAssinar.setEnabled(false);
                            bFechar.setEnabled(false);
                            Assinador.this.progressBar.setVisible(true);
                            Assinador.this.progressBar.setMinimum(0);
                            Assinador.this.progressBar.setMaximum(modelArquivos.getDataVector().size());
                            Assinador.this.progressBar.setValue(Assinador.this.progressBar.getMinimum());
                            ComunicacaoToken token = new ComunicacaoToken();
                            SmartCardKeyStore keyStore = token.abrirConexaoToken(Assinador.this.pkcsProvider, senha);
                            if (keyStore != null) {
                                int docAssinados = 0;
                                int i2 = 0;
                                while (i2 < modelArquivos.getDataVector().size()) {
                                    Vector dados = modelArquivos.getDataVector().get(i2);
                                    boolean jaAssinado = (Boolean)dados.get(2);
                                    if (!jaAssinado) {
                                        Long id = Long.parseLong(dados.get(0).toString());
                                        Documentos documento = null;
                                        for (Documentos doc : ConexaoAssinador.listaTotal) {
                                            if (!id.equals(doc.getDocID())) continue;
                                            documento = doc;
                                            break;
                                        }
                                        PrivateKey pkey = keyStore.getPrivateKey();
                                        boolean assinado = Assinador.this.service.assinarDocumento(Assinador.this.urlAssinador, keyStore.getSelectedAlias(), documento, pkey);
                                        if (assinado) {
                                            modelArquivos.setValueAt(Boolean.TRUE, i2, 2);
                                            modelArquivos.setValueAt(documento.getCodConsultaDoc(), i2, 3);
                                            ++docAssinados;
                                        }
                                    }
                                    Assinador.this.progressBar.setValue(i2 + 1);
                                    ++i2;
                                }
                                Assinador.this.progressBar.setVisible(false);
                                if (docAssinados == 0) {
                                    JOptionPane.showMessageDialog(null, "Nenhum documento foi assinado!", null, 2);
                                } else if (docAssinados == 1) {
                                    JOptionPane.showMessageDialog(null, "Documento assinado com sucesso!", null, 1);
                                } else {
                                    JOptionPane.showMessageDialog(null, String.valueOf(docAssinados) + " documentos assinados com sucesso!", null, 1);
                                }
                            }
                        }
                        catch (Exception e) {
                            Assinador.this.progressBar.setVisible(false);
                            JOptionPane.showMessageDialog(null, "N\u00e3o foi poss\u00edvel assinar os documentos: " + e.getMessage(), null, 0);
                            e.printStackTrace();
                        }
                        bAssinar.setEnabled(true);
                        bFechar.setEnabled(true);
                    }
                }).start();
            }
        } else if (e.getActionCommand().equals("Fechar")) {
            this.dispose();
        }
    }

    class IconRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String iconName = "unchecked.png";
            if (Boolean.TRUE == value) {
                iconName = "checked.png";
            }
            label.setIcon(new ImageIcon(this.getClass().getResource("/" + iconName)));
            label.setText("");
            label.setHorizontalAlignment(0);
            return label;
        }
    }
}

