/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.util;

import br.gov.pe.tce.applet.entidades.DadosCertificado;
import br.gov.pe.tce.applet.entidades.DadosToken;
import br.gov.pe.tce.applet.util.ConstantesApplet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;

public class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getName());
    private static final String hexDigits = "0123456789abcdef";

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            int j = b[i] & 0xFF;
            buf.append(hexDigits.charAt(j / 16));
            buf.append(hexDigits.charAt(j % 16));
            ++i;
        }
        return buf.toString();
    }

    public static byte[] hexStringToByteArray(String hexa) throws IllegalArgumentException {
        if (hexa.length() % 2 != 0) {
            throw new IllegalArgumentException("String hexa inv\u00ef\u00bf\u00bdlida");
        }
        byte[] b = new byte[hexa.length() / 2];
        int i = 0;
        while (i < hexa.length()) {
            b[i / 2] = (byte)(hexDigits.indexOf(hexa.charAt(i)) << 4 | hexDigits.indexOf(hexa.charAt(i + 1)));
            i += 2;
        }
        return b;
    }

    public static byte[] fileToByteArray(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, null, e);
            throw e;
        }
        byte[] arrayRetorno = bos.toByteArray();
        try {
            bos.close();
            fis.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return arrayRetorno;
    }

    public static String fileToHexString(File file) throws IOException {
        return Util.byteArrayToHexString(Util.fileToByteArray(file));
    }

    public static String getNomeArquivo(String url) {
        if (url != null && !url.isEmpty()) {
            return url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf("."));
        }
        return null;
    }

    public static String enviarParametrosServlet(HashMap<String, Object> map, String caminhoServlet) {
        String status = "";
        try {
            URL url = new URL(caminhoServlet);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream oos = new ObjectOutputStream(connection.getOutputStream());
            oos.writeObject(map);
            oos.flush();
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(connection.getInputStream());
            status = (String)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static boolean isNullOrEmpty(String valor) {
        return valor == null || valor.length() == 0;
    }

    public static String removeMascaraCpjCnpj(String valor) {
        String retorno = "";
        if (!Util.isNullOrEmpty(valor)) {
            retorno = valor.replace(".", "").replace("-", "").replace("/", "");
        }
        return retorno;
    }

    public static DadosToken getInfoAssinante(X509Certificate certificado) {
        DadosToken retorno = new DadosToken();
        DadosCertificado dadosCetificado = null;
        try {
            Collection<List<?>> col = certificado.getSubjectAlternativeNames();
            dadosCetificado = new DadosCertificado();
            for (List<?> obj : col) {
                if (!(obj instanceof ArrayList)) continue;
                ArrayList lst = (ArrayList)obj;
                Object value = lst.get(1);
                if (value instanceof ASN1Sequence) {
                    ASN1Primitive octet;
                    ASN1Sequence seq = (ASN1Sequence)value;
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)seq.getObjectAt(0);
                    ASN1TaggedObject tagged = (ASN1TaggedObject)seq.getObjectAt(1);
                    String info = null;
                    ASN1Object derObj = tagged.getBaseObject();
                    if (derObj instanceof ASN1OctetString) {
                        octet = (ASN1OctetString)derObj;
                        info = new String(((ASN1OctetString)octet).getOctets());
                    } else if (derObj instanceof ASN1PrintableString) {
                        octet = (ASN1PrintableString)derObj;
                        info = new String(((ASN1PrintableString)octet).getOctets());
                    } else if (derObj instanceof ASN1UTF8String) {
                        ASN1UTF8String str = (ASN1UTF8String)derObj;
                        info = str.getString();
                    }
                    if (info == null || info.isEmpty()) continue;
                    if (oid.equals(ConstantesApplet.OID_PF_DADOS_TITULAR) || oid.equals(ConstantesApplet.OID_PJ_DADOS_RESPONSAVEL)) {
                        String nascimento = info.substring(0, 8);
                        dadosCetificado.setDataNascimento(new SimpleDateFormat("ddMMyyyy").parse(nascimento));
                        String cpf = info.substring(8, 19);
                        dadosCetificado.setCpf(cpf);
                        String nis = info.substring(19, 30);
                        dadosCetificado.setNis(nis);
                        String rg = info.substring(30, 45);
                        dadosCetificado.setRg(rg);
                        if (rg.equals("000000000000000")) continue;
                        String ufExp = info.substring(45, 50);
                        dadosCetificado.setUfExp(ufExp);
                        continue;
                    }
                    if (oid.equals(ConstantesApplet.OID_PF_INSS)) {
                        String inss = info.substring(0, 12);
                        dadosCetificado.setInss(inss);
                        continue;
                    }
                    if (oid.equals(ConstantesApplet.OID_PF_ELEITORAL)) {
                        String titulo = info.substring(0, 12);
                        dadosCetificado.setTituloEleitor(titulo);
                        String zona = info.substring(12, 15);
                        dadosCetificado.setZonaEleitoral(zona);
                        String secao = info.substring(15, 19);
                        dadosCetificado.setSecao(secao);
                        if (titulo.equals("000000000000")) continue;
                        String municipio = info.substring(19, 41);
                        dadosCetificado.setMunicipio(municipio);
                        continue;
                    }
                    if (oid.equals(ConstantesApplet.OID_PJ_RESPONSAVEL)) {
                        dadosCetificado.setResponsavel(info);
                        continue;
                    }
                    if (oid.equals(ConstantesApplet.OID_PJ_CNPJ)) {
                        dadosCetificado.setCnpj(info);
                        continue;
                    }
                    if (oid.equals(ConstantesApplet.OID_PJ_INSS)) {
                        dadosCetificado.setInss(info);
                        continue;
                    }
                    if (!oid.equals(ConstantesApplet.OID_PJ_NOME_EMPRESARIAL)) continue;
                    dadosCetificado.setNomeEmpresarial(info);
                    continue;
                }
                System.out.println("Valor desconhecido: " + value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retorno;
    }
}

