/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.util;

import br.gov.pe.tce.applet.util.AssinadorException;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public class AuthUtil {
    public static String getAccessToken(String username, String password) throws AssinadorException {
        HttpURLConnection conn = null;
        try {
            String line;
            URL url = new URL("https://portal.tce.pe.gov.br/auth/realms/sistemas/protocol/openid-connect/token");
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("client_id", "assinar");
            params.put("client_secret", "e941461d-b99c-4c66-923b-6ac594501683");
            params.put("grant_type", "password");
            params.put("username", username);
            params.put("password", password);
            StringBuilder postData = new StringBuilder();
            for (Map.Entry param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode((String)param.getKey(), StandardCharsets.UTF_8.name()));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), StandardCharsets.UTF_8.name()));
            }
            byte[] postDataBytes = postData.toString().getBytes(StandardCharsets.UTF_8.name());
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.getOutputStream().write(postDataBytes);
            if (conn.getResponseCode() != 200) {
                return null;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            String json = result.toString();
            reader.close();
            JsonObject jsonObject = new Gson().fromJson(json, JsonObject.class);
            if (jsonObject != null && jsonObject.has("access_token")) {
                String token;
                String string = token = jsonObject.get("access_token").getAsString();
                return string;
            }
        }
        catch (Exception e) {
            throw new AssinadorException(e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }
}

