/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.token;

import br.gov.pe.tce.applet.token.SignerKeyStore;
import br.gov.pe.tce.applet.token.SmartCardType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.pkcs11.SunPKCS11;

public class SmartCardKeyStore
implements SignerKeyStore,
Serializable {
    private static final long serialVersionUID = -4170463404098163261L;
    private static SmartCardKeyStore instance;
    private Provider pkcsProvider;
    private ArrayList<String> aliases;
    private Hashtable privateKeys;
    private Hashtable certificates;
    private Hashtable certChains;
    private String selectedAlias;
    private static final String ERRO_INICIALIZACAO_SMARTCARD = "Erro para inicializar o smartcard.";
    private static final String ERRO_PIN_INCORRETO = "Pin incorreto.";
    private static final String ERRO_SMARTCARD_REMOVIDO = "Smartcard removido.";
    private static final String ERRO_LEITURA_SMARTCARD = "Erro na leitura do smartcard.";
    private static final String ERRO_SMARTCARD_SEM_CERTIFICADO = "Smartcard sem certificado.";
    private static final String ERRO_POLITICA_SEGURANCA = "Erro pol\u00edtica de seguran\u00e7a";
    private static final String ERRO_PIN_BLOQUEADO = "Pin bloqueado";

    private SmartCardKeyStore() {
    }

    public static synchronized SmartCardKeyStore getInstance() {
        if (instance == null) {
            instance = new SmartCardKeyStore();
        }
        return instance;
    }

    private Provider createProvider(SmartCardType type) throws IOException {
        SunPKCS11 provider = new SunPKCS11((InputStream)new ByteArrayInputStream(type.config.getBytes()));
        this.pkcsProvider = provider;
        Security.addProvider(this.pkcsProvider);
        return this.pkcsProvider;
    }

    public KeyStore returnKeystore(char[] pin) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore smartCardKS = KeyStore.getInstance("PKCS11");
        smartCardKS.load(null, pin);
        return smartCardKS;
    }

    private void initializeSmartCard(char[] pin) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException, UnrecoverableKeyException {
        KeyStore smartCardKS = KeyStore.getInstance("PKCS11");
        smartCardKS.load(null, pin);
        this.privateKeys = new Hashtable();
        this.certChains = new Hashtable();
        this.certificates = new Hashtable();
        this.aliases = new ArrayList();
        Enumeration<String> enumAliases = smartCardKS.aliases();
        System.setProperty("javax.net.ssl.keyStoreType", "PKCS11");
        System.setProperty("javax.net.ssl.keyStore", "NONE");
        System.setProperty("javax.net.ssl.keyStoreProvider", smartCardKS.getProvider().getName());
        System.setProperty("javax.net.ssl.keyStorePassword", new String(pin));
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        System.setProperty("javax.net.ssl.trustStore", "c:/nfe/certificados/KeyStore.jks");
        while (enumAliases.hasMoreElements()) {
            String alias = enumAliases.nextElement();
            if (smartCardKS.getCertificateChain(alias) == null) continue;
            this.aliases.add(alias);
            X509Certificate certificate = (X509Certificate)smartCardKS.getCertificate(alias);
            X509Certificate[] certChain = (X509Certificate[])smartCardKS.getCertificateChain(alias);
            PrivateKey pkey = (PrivateKey)smartCardKS.getKey(alias, pin);
            this.certificates.put(alias, certificate);
            this.privateKeys.put(alias, pkey);
            this.certChains.put(alias, certChain);
            break;
        }
        if (this.aliases.size() == 0) {
            throw new KeyStoreException(ERRO_SMARTCARD_SEM_CERTIFICADO);
        }
        this.selectedAlias = this.aliases.get(0);
    }

    public Provider openDLL() throws IOException {
        SmartCardType[] smartCardTypeArray = SmartCardType.values();
        int n = smartCardTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SmartCardType type = smartCardTypeArray[n2];
            try {
                this.createProvider(type);
                break;
            }
            catch (ProviderException pe) {
                this.pkcsProvider = null;
                ++n2;
            }
        }
        return this.pkcsProvider;
    }

    /*
     * Unable to fully structure code
     */
    public void open(Provider pkcsProvider, char[] pin) throws Exception {
        block16: {
            block17: {
                block18: {
                    block19: {
                        if (pkcsProvider != null) break block19;
                        this.privateKeys = new Hashtable<K, V>();
                        this.certChains = new Hashtable<K, V>();
                        this.certificates = new Hashtable<K, V>();
                        this.aliases = new ArrayList<E>();
                        this.aliases = new ArrayList<E>();
                        try {
                            ks = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
                            ks.load(null, pin);
                            aliasEnum = ks.aliases();
                            aliasKey = aliasEnum.nextElement();
                            if (ks.getCertificateChain(aliasKey) == null) ** GOTO lbl62
                            this.selectedAlias = aliasKey;
                            this.aliases.add(aliasKey);
                            certificate = (X509Certificate)ks.getCertificate(aliasKey);
                            certChain = (X509Certificate[])ks.getCertificateChain(aliasKey);
                            pkey = (PrivateKey)ks.getKey(aliasKey, pin);
                            this.certificates.put(aliasKey, certificate);
                            this.privateKeys.put(aliasKey, pkey);
                            this.certChains.put(aliasKey, certChain);
                        }
                        catch (KeyStoreException e) {
                            throw new Exception("Erro para inicializar o smartcard.");
                        }
                        catch (NoSuchProviderException e) {
                            throw new Exception(e.getMessage());
                        }
                    }
                    try {
                        this.initializeSmartCard(pin);
                        break block16;
                    }
                    catch (Exception e) {
                        message = e.getMessage();
                        if (e instanceof KeyStoreException) {
                            message = "Erro para inicializar o smartcard.";
                            break block17;
                        }
                        if (!(e instanceof IOException)) break block18;
                        cause = e.getCause();
                        ** while (cause != null && cause.getMessage() == null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        cause = cause.getCause();
                        continue;
                    }
lbl44:
                    // 1 sources

                    if (cause != null) {
                        if ("CKR_PIN_INCORRECT".equals(cause.getMessage())) {
                            message = "Pin incorreto.";
                        } else if ("CKR_FUNCTION_FAILED".equals(cause.getMessage())) {
                            message = "Erro na leitura do smartcard.";
                        } else if ("CKR_PIN_LOCKED".equals(cause.getMessage())) {
                            message = "Pin bloqueado";
                        }
                    }
                    break block17;
                }
                if (e instanceof ProviderException && "Token has been removed".equals(e.getMessage())) {
                    message = "Smartcard removido.";
                } else if (e instanceof AccessControlException) {
                    message = "Erro pol\u00edtica de seguran\u00e7a";
                }
            }
            throw new Exception(message);
        }
    }

    @Override
    public Certificate[] getCertChain() {
        return (Certificate[])this.certChains.get(this.selectedAlias);
    }

    @Override
    public Certificate getCertificate() {
        return (Certificate)this.certificates.get(this.selectedAlias);
    }

    @Override
    public PrivateKey getPrivateKey() {
        return (PrivateKey)this.privateKeys.get(this.selectedAlias);
    }

    @Override
    public Provider getProvider() {
        return this.pkcsProvider;
    }

    public Provider getPkcsProvider() {
        return this.pkcsProvider;
    }

    public void setPkcsProvider(Provider pkcsProvider) {
        this.pkcsProvider = pkcsProvider;
    }

    public ArrayList<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(ArrayList<String> aliases) {
        this.aliases = aliases;
    }

    public Hashtable getPrivateKeys() {
        return this.privateKeys;
    }

    public void setPrivateKeys(Hashtable privateKeys) {
        this.privateKeys = privateKeys;
    }

    public Hashtable getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Hashtable certificates) {
        this.certificates = certificates;
    }

    public Hashtable getCertChains() {
        return this.certChains;
    }

    public void setCertChains(Hashtable certChains) {
        this.certChains = certChains;
    }

    public String getSelectedAlias() {
        return this.selectedAlias;
    }

    public void setSelectedAlias(String selectedAlias) {
        this.selectedAlias = selectedAlias;
    }
}

