/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.token;

import br.gov.pe.tce.applet.entidades.DadosCertificado;
import br.gov.pe.tce.applet.token.CardSignerInformation;
import br.gov.pe.tce.applet.token.SmartCardKeyStore;
import br.gov.pe.tce.applet.util.Util;
import java.io.IOException;
import java.security.Provider;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public class ComunicacaoToken {
    public Provider loadSmartCardDLL() throws IOException {
        SmartCardKeyStore scks = SmartCardKeyStore.getInstance();
        return scks.openDLL();
    }

    public SmartCardKeyStore abrirConexaoToken(Provider pkcsProvider, String numPin) throws Exception {
        SmartCardKeyStore keyStore = null;
        keyStore = this.loadSmartCard(pkcsProvider, numPin);
        boolean dadosValidos = this.dadosValidos(keyStore, "Valido");
        if (!dadosValidos) {
            keyStore = null;
            throw new Exception("Dados inv\u00e1lidos!");
        }
        return keyStore;
    }

    private SmartCardKeyStore loadSmartCard(Provider pkcsProvider, String password) throws Exception {
        SmartCardKeyStore scks = SmartCardKeyStore.getInstance();
        scks.open(pkcsProvider, password.toCharArray());
        return scks;
    }

    private boolean dadosValidos(SmartCardKeyStore keyStore, String idUsuario) {
        DadosCertificado dadosCertificado;
        X509Certificate cert = (X509Certificate)keyStore.getCertChain()[0];
        if (cert != null && !this.certificadoValido(cert)) {
            return false;
        }
        return Util.isNullOrEmpty(idUsuario) || (dadosCertificado = CardSignerInformation.getInstance(cert).getDadosCertificado()) != null && dadosCertificado.getCpf() != null && !dadosCertificado.getCpf().isEmpty();
    }

    private boolean certificadoValido(X509Certificate cert) {
        try {
            cert.checkValidity();
            return true;
        }
        catch (CertificateExpiredException E) {
            this.setMsgErro("Certificado expirado!");
            return false;
        }
        catch (CertificateNotYetValidException E) {
            this.setMsgErro("Certificado inv\u00e1lido!");
            return false;
        }
    }

    public void setMsgErro(String msgErro) {
    }
}

