/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.token;

import br.gov.pe.tce.applet.entidades.DadosCertificado;
import br.gov.pe.tce.applet.util.ConstantesApplet;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;

public class CardSignerInformation {
    private static CardSignerInformation instance;
    public X509Certificate certificado;

    public static CardSignerInformation getInstance(X509Certificate certificado) {
        if (instance == null) {
            instance = new CardSignerInformation(certificado);
        }
        return instance;
    }

    private CardSignerInformation(X509Certificate certificado) {
        this.certificado = certificado;
    }

    public DadosCertificado getDadosCertificado() {
        DadosCertificado dadosCertificado = new DadosCertificado();
        try {
            Collection<List<?>> altNames = this.certificado.getSubjectAlternativeNames();
            for (List<?> item : altNames) {
                Integer type = (Integer)item.get(0);
                if (type == 0) {
                    ASN1InputStream decoder = new ASN1InputStream((byte[])item.toArray()[1]);
                    ASN1Sequence sequence = (ASN1Sequence)decoder.readObject();
                    ASN1ObjectIdentifier objectIdentifier = (ASN1ObjectIdentifier)sequence.getObjectAt(0);
                    ASN1TaggedObject tag = (ASN1TaggedObject)sequence.getObjectAt(1);
                    ASN1Object derObj = tag.getBaseObject();
                    String info = new String(derObj.getEncoded()).substring(4);
                    if (objectIdentifier.equals(ConstantesApplet.OID_PF_DADOS_TITULAR) || objectIdentifier.equals(ConstantesApplet.OID_PJ_DADOS_RESPONSAVEL)) {
                        String nascimento = info.substring(0, 8);
                        dadosCertificado.setDataNascimento(new SimpleDateFormat("ddMMyyyy").parse(nascimento));
                        String cpf = info.substring(8, 19);
                        dadosCertificado.setCpf(cpf);
                        String nis = info.substring(19, 30);
                        dadosCertificado.setNis(nis);
                        String rg = info.substring(30, 45);
                        dadosCertificado.setRg(rg);
                        if (!rg.equals("000000000000000")) {
                            String ufExp = info.substring(45, 50);
                            dadosCertificado.setUfExp(ufExp);
                        }
                    } else if (objectIdentifier.equals(ConstantesApplet.OID_PF_INSS)) {
                        String inss = info.substring(0, 12);
                        dadosCertificado.setInss(inss);
                    } else if (objectIdentifier.equals(ConstantesApplet.OID_PF_ELEITORAL)) {
                        String titulo = info.substring(0, 12);
                        dadosCertificado.setTituloEleitor(titulo);
                        String zona = info.substring(12, 15);
                        dadosCertificado.setZonaEleitoral(zona);
                        String secao = info.substring(15, 19);
                        dadosCertificado.setSecao(secao);
                        if (!titulo.equals("000000000000")) {
                            String municipio = info.substring(19, 41);
                            dadosCertificado.setMunicipio(municipio);
                        }
                    } else if (objectIdentifier.equals(ConstantesApplet.OID_PJ_RESPONSAVEL)) {
                        dadosCertificado.setResponsavel(info);
                    } else if (objectIdentifier.equals(ConstantesApplet.OID_PJ_CNPJ)) {
                        dadosCertificado.setCnpj(info);
                    } else if (objectIdentifier.equals(ConstantesApplet.OID_PJ_INSS)) {
                        dadosCertificado.setInss(info);
                    } else if (objectIdentifier.equals(ConstantesApplet.OID_PJ_NOME_EMPRESARIAL)) {
                        dadosCertificado.setNomeEmpresarial(info);
                    } else if (objectIdentifier.equals(ConstantesApplet.OID_NT_PRINCIPAL_NAME)) {
                        dadosCertificado.setInternalName(info);
                    }
                    decoder.close();
                    continue;
                }
                if (type != 1) continue;
                dadosCertificado.setRfc822Name(item.get(1).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dadosCertificado;
    }

    public X509Certificate getCertificado() {
        return this.certificado;
    }

    public void setCertificado(X509Certificate certificado) {
        this.certificado = certificado;
    }
}

