/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.service;

import br.gov.pe.tce.applet.entidades.ArquivoAssinatura;
import br.gov.pe.tce.applet.entidades.AssinadorRequest;
import br.gov.pe.tce.applet.entidades.DadosCertificado;
import br.gov.pe.tce.applet.entidades.ModoAssinatura;
import br.gov.pe.tce.applet.entidades.SolicitacaoArquivo;
import br.gov.pe.tce.applet.service.ConexaoAssinadorNovo;
import br.gov.pe.tce.applet.token.CardSignerInformation;
import br.gov.pe.tce.applet.token.SmartCardKeyStore;
import br.gov.pe.tce.applet.util.AssinadorException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class ServiceNovo {
    ConexaoAssinadorNovo assinadorNovo = new ConexaoAssinadorNovo();

    public List<SolicitacaoArquivo> getArquivosSolicitacaoAssinatura(AssinadorRequest assinadorRequest) throws AssinadorException {
        return this.assinadorNovo.getArquivosSolicitacaoAssinatura(assinadorRequest);
    }

    private void validarCpfAssinatura(X509Certificate certificado, SolicitacaoArquivo arquivo, AssinadorRequest assinadorRequest) throws Exception {
        boolean cpfSaoIguais;
        DadosCertificado dadosCertificado = CardSignerInformation.getInstance(certificado).getDadosCertificado();
        String cpfSolicitante = this.assinadorNovo.obterCpfSolicitante(arquivo.getCodigoArquivo(), assinadorRequest);
        boolean bl = cpfSaoIguais = dadosCertificado != null && cpfSolicitante != null && dadosCertificado.getCpf() != null && cpfSolicitante.equalsIgnoreCase(dadosCertificado.getCpf());
        if (!cpfSaoIguais) {
            throw new AssinadorException("Voc\u00ea n\u00e3o pode assinar um documento de outra pessoa!");
        }
    }

    public String assinarDocumento(AssinadorRequest assinadorRequest, SolicitacaoArquivo arquivo, SmartCardKeyStore keyStore) throws Exception {
        X500Principal principal;
        Object certificate;
        PrivateKey pkey = keyStore.getPrivateKey();
        String dadosAssinador = keyStore.getSelectedAlias();
        String[] dados = dadosAssinador.split(":");
        String ouAssinatura = null;
        if (keyStore.getCertificates() != null && keyStore.getCertificates().containsKey(dadosAssinador) && (certificate = keyStore.getCertificates().get(dadosAssinador)) instanceof X509Certificate && (principal = ((X509Certificate)certificate).getSubjectX500Principal()) != null) {
            ouAssinatura = principal.getName();
            int tamanhoMaximoOUAssinatura = 400;
            if (ouAssinatura != null && ouAssinatura.length() > tamanhoMaximoOUAssinatura) {
                ouAssinatura = ouAssinatura.substring(0, tamanhoMaximoOUAssinatura);
            }
        }
        if (ouAssinatura == null) {
            ouAssinatura = "";
        }
        X509Certificate certicado = (X509Certificate)keyStore.getCertificate();
        this.validarCpfAssinatura(certicado, arquivo, assinadorRequest);
        ArquivoAssinatura assinatura = null;
        assinatura = arquivo.getModoAssinatura() == ModoAssinatura.PDF_STAMP ? ServiceNovo.signHash(arquivo.getHashOriginal(), pkey) : ServiceNovo.signP7s(pkey, keyStore, certicado, arquivo.getHashOriginal());
        assinatura.setSolicitacaoArquivoId(arquivo.getId());
        assinatura.setCertChain(pkey.toString());
        assinatura.setCnAssinatura1(dados.length > 0 ? dados[0] : "");
        assinatura.setCnAssinatura2(dados.length > 1 ? dados[1] : "");
        assinatura.setOuAssinatura(ouAssinatura);
        assinatura.setTipoCertificado("A3");
        return this.assinadorNovo.assinarDocumento(assinatura, assinadorRequest);
    }

    public static ArquivoAssinatura signP7s(PrivateKey pkey, SmartCardKeyStore keyStore, X509Certificate certicado, String hashOriginal) throws OperatorCreationException, CertificateEncodingException, CMSException, FileNotFoundException, IOException {
        ArquivoAssinatura assinatura = new ArquivoAssinatura();
        String signatureInstance = "SHA256withRSA";
        try {
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signatureInstance);
            generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(signerBuilder.build(pkey), new JcaX509CertificateHolder(certicado)));
            generator.addCertificate(new JcaX509CertificateHolder(certicado));
            CMSProcessableByteArray byteArray = new CMSProcessableByteArray(hashOriginal.getBytes());
            CMSSignedData signedData = generator.generate(byteArray, true);
            assinatura.setArquivoAssinatura(signedData.getEncoded());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        assinatura.setTipoAssinatura(signatureInstance);
        assinatura.setHashAssinado(ModoAssinatura.P7S.toString());
        return assinatura;
    }

    public static ArquivoAssinatura signHash(String samlResponseString, PrivateKey pkey) throws Exception {
        ArquivoAssinatura assinatura = new ArquivoAssinatura();
        String signedString = null;
        String signatureInstance = "SHA256withRSA";
        Signature signature = Signature.getInstance(signatureInstance);
        try {
            signature.initSign(pkey);
            signature.update(samlResponseString.getBytes());
            byte[] signatureBytes = signature.sign();
            byte[] encryptedByteValue = Base64.getEncoder().encode(signatureBytes);
            signedString = new String(encryptedByteValue, StandardCharsets.UTF_8);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            signatureInstance = "MD5";
            MessageDigest m = MessageDigest.getInstance(signatureInstance);
            m.update(samlResponseString.getBytes(), 0, samlResponseString.length());
            signedString = new BigInteger(1, m.digest()).toString(16);
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        assinatura.setTipoAssinatura(signatureInstance);
        assinatura.setHashAssinado(signedString);
        return assinatura;
    }

    public Boolean verificarSeUsuarioLogadoEoMesmoSolicitacao(AssinadorRequest assinadorRequest) throws Exception {
        return this.assinadorNovo.verificarSeUsuarioLogadoEoMesmoSolicitacao(assinadorRequest);
    }
}

