/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.service;

import br.gov.pe.tce.applet.entidades.Assinantes;
import br.gov.pe.tce.applet.entidades.Documentos;
import br.gov.pe.tce.applet.service.ConexaoAssinador;
import br.gov.pe.tce.applet.view.MyTableModel;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class Service {
    ConexaoAssinador assinador = new ConexaoAssinador();

    public MyTableModel gerarDocumentosParaAssinar(String ids, String urlAssinador) throws JsonSyntaxException, IOException {
        MyTableModel model = new MyTableModel();
        List<Documentos> lista = this.assinador.consultarDocumentos(ids, urlAssinador);
        for (Documentos documento : lista) {
            String nomedoc = String.valueOf(URLDecoder.decode(documento.getNomeDoc(), "UTF-8")) + "." + documento.getExtensaoDoc();
            model.addRow(new Object[]{documento.getDocID(), nomedoc, false, ""});
        }
        return model;
    }

    public boolean assinarDocumento(String urlAssinador, String dadosAssinador, Documentos doc, PrivateKey pkey) throws Exception {
        String[] dados = dadosAssinador.split(":");
        Assinantes assinantes = new Assinantes();
        assinantes.setMatriculaAssinante(dados[1].toString());
        assinantes.setNomeAssinante(dados[0].toString());
        assinantes.setTipoAssinatura("A3");
        assinantes.setInforAssinatura(dadosAssinador);
        assinantes.setCertchain(pkey.toString());
        assinantes.setTpSignature("MD5");
        assinantes.setPerfilAssinatura(doc.getNomeSistema());
        assinantes.setHashDocAssinado(Service.signHash(doc.getHashDocOriginal(), pkey));
        doc.setListaAssinantes(new ArrayList<Assinantes>());
        doc.getListaAssinantes().add(assinantes);
        return this.assinador.assinarDocumento(doc, urlAssinador);
    }

    public static String signHash(String samlResponseString, PrivateKey pkey) throws Exception {
        String signedString = null;
        Signature signature = Signature.getInstance("SHA256withRSA");
        try {
            signature.initSign(pkey);
            signature.update(samlResponseString.getBytes());
            byte[] signatureBytes = signature.sign();
            byte[] encryptedByteValue = Base64.getEncoder().encode(signatureBytes);
            signedString = new String(encryptedByteValue, StandardCharsets.UTF_8);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(samlResponseString.getBytes(), 0, samlResponseString.length());
            signedString = new BigInteger(1, m.digest()).toString(16);
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return signedString;
    }
}

