/*
 * Decompiled with CFR 0.152.
 */
package br.gov.pe.tce.applet.service;

import br.gov.pe.tce.applet.entidades.ArquivoAssinatura;
import br.gov.pe.tce.applet.entidades.AssinadorRequest;
import br.gov.pe.tce.applet.entidades.SolicitacaoArquivo;
import br.gov.pe.tce.applet.util.AssinadorException;
import br.gov.pe.tce.applet.util.AuthUtil;
import br.gov.pe.tce.applet.util.LocalDateTimeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ConexaoAssinadorNovo {
    HttpClient client = HttpClientBuilder.create().build();
    public static List<SolicitacaoArquivo> listaTotal;

    private String getAccessToken(AssinadorRequest assinadorRequest) throws AssinadorException {
        String accessToken = AuthUtil.getAccessToken(assinadorRequest.getUsername(), assinadorRequest.getPassword());
        if (accessToken == null) {
            throw new AssinadorException("N\u00e3o foi poss\u00edvel autenticar seu usu\u00e1rio neste momento!");
        }
        return accessToken;
    }

    public List<SolicitacaoArquivo> getArquivosSolicitacaoAssinatura(AssinadorRequest assinadorRequest) throws AssinadorException {
        List<SolicitacaoArquivo> arquivos = new ArrayList();
        try {
            String accessToken = this.getAccessToken(assinadorRequest);
            URL url = new URL(String.valueOf(assinadorRequest.getUrlAssinador()) + "/api/assinador/solicitacao-arquivos/" + assinadorRequest.getHashSolicitacao());
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Authorization", "Bearer " + accessToken);
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                Throwable throwable = null;
                Object var8_12 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8));){
                    String inputLine;
                    StringBuilder jsonBuilder = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        jsonBuilder.append(inputLine);
                    }
                    Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeAdapter().nullSafe()).disableHtmlEscaping().create();
                    Type collectionType = new TypeToken<Collection<SolicitacaoArquivo>>(){}.getType();
                    arquivos = (List)gson.fromJson(jsonBuilder.toString(), collectionType);
                    if (arquivos.isEmpty()) {
                        throw new AssinadorException("N\u00e3o foram encontrados documentos para a solicita\u00e7\u00e3o com hashSolicitacao = " + assinadorRequest.getHashSolicitacao());
                    }
                    listaTotal = arquivos;
                    return arquivos;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (urlConnection.getErrorStream() != null) {
                Throwable throwable = null;
                Object var8_14 = null;
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), StandardCharsets.UTF_8));
                    try {
                        StringBuilder result = new StringBuilder();
                        String line = "";
                        while ((line = in.readLine()) != null) {
                            result.append(line);
                        }
                        throw new AssinadorException(result.toString());
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            in.close();
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            throw new AssinadorException("N\u00e3o foi poss\u00edvel carregar os documentos");
        }
        catch (IOException e) {
            throw new AssinadorException("Servi\u00e7o do assinador n\u00e3o est\u00e1 dispon\u00edvel!");
        }
    }

    /*
     * Exception decompiling
     */
    public String assinarDocumento(ArquivoAssinatura arquivoAssinatura, AssinadorRequest assinadorRequest) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String obterCpfSolicitante(String codigoArquivo, AssinadorRequest assinadorRequest) throws Exception {
        String accessToken = this.getAccessToken(assinadorRequest);
        try {
            URL url = new URL(String.valueOf(assinadorRequest.getUrlAssinador()) + "/api/assinador/usuario-solicitacao/" + codigoArquivo);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Authorization", "Bearer " + accessToken);
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                Throwable throwable = null;
                Object var8_12 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8));){
                    String inputLine;
                    Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeAdapter().nullSafe()).disableHtmlEscaping().create();
                    String cpfSolicitante = null;
                    while ((inputLine = in.readLine()) != null) {
                        cpfSolicitante = gson.fromJson(inputLine, String.class);
                    }
                    if (cpfSolicitante == null || cpfSolicitante.isEmpty() || cpfSolicitante.length() != 11) {
                        throw new AssinadorException("N\u00e3o foi poss\u00edvel localizar o CPF do usu\u00e1rio que realizou esta solicita\u00e7\u00e3o de assinatura!");
                    }
                    return cpfSolicitante;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (urlConnection.getErrorStream() != null) {
                Throwable throwable = null;
                Object var8_14 = null;
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), StandardCharsets.UTF_8));
                    try {
                        StringBuilder result = new StringBuilder();
                        String line = "";
                        while ((line = in.readLine()) != null) {
                            result.append(line);
                        }
                        throw new AssinadorException(result.toString());
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            in.close();
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            throw new AssinadorException("Ocorreu um erro ao tentar localizar o CPF do usu\u00e1rio que solicitou esta assinatura!");
        }
        catch (IOException e) {
            throw new AssinadorException("Servi\u00e7o do assinador n\u00e3o est\u00e1 dispon\u00edvel!");
        }
    }

    public Boolean verificarSeUsuarioLogadoEoMesmoSolicitacao(AssinadorRequest assinadorRequest) throws Exception {
        String accessToken = this.getAccessToken(assinadorRequest);
        try {
            URL url = new URL(String.valueOf(assinadorRequest.getUrlAssinador()) + "/api/assinador/usuario-solicitacao/" + assinadorRequest.getHashSolicitacao() + "/" + assinadorRequest.getUsername());
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Authorization", "Bearer " + accessToken);
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                Throwable throwable = null;
                Object var7_11 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8));){
                    String inputLine;
                    Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeAdapter().nullSafe()).disableHtmlEscaping().create();
                    Boolean usuarioLogadoIgualSolicitacao = null;
                    while ((inputLine = in.readLine()) != null) {
                        usuarioLogadoIgualSolicitacao = gson.fromJson(inputLine, Boolean.class);
                    }
                    if (usuarioLogadoIgualSolicitacao == null) {
                        throw new AssinadorException("N\u00e3o foi poss\u00edvel identificar o usu\u00e1rio que realizou esta solicita\u00e7\u00e3o de assinatura!");
                    }
                    return usuarioLogadoIgualSolicitacao;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (urlConnection.getErrorStream() != null) {
                Throwable throwable = null;
                Object var7_13 = null;
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), StandardCharsets.UTF_8));
                    try {
                        StringBuilder result = new StringBuilder();
                        String line = "";
                        while ((line = in.readLine()) != null) {
                            result.append(line);
                        }
                        throw new AssinadorException(result.toString());
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            in.close();
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            throw new AssinadorException("Ocorreu um erro ao tentar localizar o CPF do usu\u00e1rio que solicitou esta assinatura!");
        }
        catch (IOException e) {
            throw new AssinadorException("Servi\u00e7o do assinador n\u00e3o est\u00e1 dispon\u00edvel!");
        }
    }
}

